/// annual averages using the full set 
clear 
*use "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Control Banks/Control_Data/Stack/fullvars_stack.dta"
use "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Control Banks\Control_Data\Stack\fullvars_stack.dta", clear
*** the below is used to construct pre and post-crisis averages
gen imp_minus_market = impvol - market_imp 
gen vol_minus_market = vol_thirty - market_vol 
gen imp_div_market = impvol/market_imp
gen vol_div_market=vol_thirty/market_vol 
gen crisis = . 
replace crisis = 0 if year >= 2002 & year <= 2007 
replace crisis = 1 if year >= 2010 & year <= 2015 
drop if year == 2016 
**replace crisis = 2 if year == 2015  
drop if crisis == . 
gen big6 = 0 
replace big6 = 1 if name == "baml" | name == "ms" | name == "jpm" | name == "gs" | name == "wf" | name == "citi"

by crisis name, sort: egen beta_crisis = mean(beta)
by crisis name, sort: egen cds_crisis = mean(cds)
by crisis name, sort: egen vol_crisis = mean(vol) 
by crisis name, sort: egen impvol_crisis = mean(impvol)
by crisis name, sort: egen ptb_crisis = mean(ptb)
by crisis name, sort: egen imp_minus_market_crisis = mean(imp_minus_market)
by crisis name, sort: egen vol_minus_market_crisis = mean(vol_minus_market)
by crisis name, sort: egen vol_div_market_crisis = mean(vol_div_market)
by crisis name, sort: egen imp_div_market_crisis = mean(imp_div_market)
by crisis name, sort: egen markcap_crisis = mean(markcap)
drop output_indicator
by crisis name, sort: gen output_indicator = _n 

br name crisis markcap_crisis vol_crisis vol_div_market_crisis vol_minus_market_crisis impvol_crisis imp_div_market_crisis imp_minus_market_crisis beta_crisis cds_crisis ptb_crisis if output_indicator == 1 & crisis != . & big6 == 1  
*** just PTB results for PTB MVE table
br name crisis markcap_crisis ptb_crisis if output_indicator == 1 & crisis != . & big6 == 1  

*** weighted mean 
by crisis big6, sort: egen beta_crisis_weight = wtmean(beta), weight(markcap)
by crisis big6, sort: egen cds_crisis_weight = wtmean(cds), weight(markcap)
by crisis big6, sort: egen vol_crisis_weight = wtmean(vol), weight(markcap)
by crisis big6, sort: egen impvol_crisis_weight = wtmean(impvol), weight(markcap)
by crisis big6, sort: egen ptb_crisis_weight = wtmean(ptb), weight(markcap)
by crisis big6, sort: egen imp_minus_market_weight = wtmean(imp_minus_market), weight(markcap)
by crisis big6, sort: egen vol_minus_market_weight = wtmean(vol_minus_market), weight(markcap)
by crisis big6, sort: egen vol_div_market_weight = wtmean(vol_div_market), weight(markcap)
by crisis big6, sort: egen imp_div_market_weight = wtmean(imp_div_market), weight(markcap)

****mean
by crisis big6, sort: egen beta_mean = mean(beta)
by crisis big6, sort: egen cds_mean = mean(cds)
by crisis big6, sort: egen vol_mean = mean(vol) 
by crisis big6, sort: egen impvol_mean = mean(impvol)
by crisis big6, sort: egen ptb_mean = mean(ptb)
by crisis big6, sort: egen imp_minus_market_mean = mean(imp_minus_market)
by crisis big6, sort: egen vol_minus_market_mean = mean(vol_minus_market)
by crisis big6, sort: egen vol_div_market_mean = mean(vol_div_market)
by crisis big6, sort: egen imp_div_market_mean = mean(imp_div_market)
by crisis big6, sort: egen markcap_mean = mean(markcap)


****median
by crisis big6, sort: egen beta_median = median(beta)
by crisis big6, sort: egen cds_median = median(cds)
by crisis big6, sort: egen vol_median = median(vol) 
by crisis big6, sort: egen impvol_median = median(impvol)
by crisis big6, sort: egen ptb_median = median(ptb)
by crisis big6, sort: egen imp_minus_market_median = median(imp_minus_market)
by crisis big6, sort: egen vol_minus_market_median = median(vol_minus_market)
by crisis big6, sort: egen vol_div_market_median = median(vol_div_market)
by crisis big6, sort: egen imp_div_market_median = median(imp_div_market)
by crisis big6, sort: egen markcap_median = median(markcap)


drop output_indicator
by crisis big6, sort: gen output_indicator = _n 

br crisis beta_crisis_weight beta_mean beta_median cds_crisis_weight cds_mean cds_median vol_crisis_weight vol_mean vol_median impvol_crisis_weight impvol_mean impvol_median ptb_crisis_weight ptb_mean ptb_median imp_div_market_weight imp_div_market_mean imp_div_market_median vol_div_market_weight vol_div_market_mean vol_div_market_median if big6 == 1 & output_indicator == 1
br crisis ptb_mean ptb_median if big6 == 1 & output_indicator == 1
